
/***********************************************************************************************
This do file outputs all tables for school and teacher-level outcomes.

***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
clear matrix;
set more off;
set mem 500M;
estimates clear;
set matsize 2000;
set maxvar 32000;
version 10;

global sass_data "C:/Users/nschwart/Desktop/nclb_final/sass_folder/raw_data";
global ccd_data "C:/Users/nschwart/Desktop/nclb_final/ccd_folder/final_data";
global tables "C:/Users/nschwart/Desktop/nclb_final/sass_folder/tables";

/*Collect files and outcomes*/
global s_resource_outcomes "avg_class ma_dummy";
global c_resource_outcomes "salplusben_2009 pup_tch";
global time_outcomes "departmentalized academic_time math_ELA_ratio_alt math_ratio_alt ELA_ratio_alt sci_ratio_alt ss_ratio_alt";
global t_climate_outcomes "z_sch_disc z_stu_cult";
global p_climate_outcomes "skills_or_excellence";
global false_outcomes "povpct hhinc emppop frac_enroll pct_black pct_hisp";
global engagement_vars "z_p_tardiness z_p_absent z_p_classcut z_p_dropout z_p_apathy z_p_preparation";

global files "assign_elmid lunch50ormore_assign_elmid";

/*CITS CCD Resource Regressions*/

use "$ccd_data/dist_expend.dta", clear;

foreach h of global c_resource_outcomes {;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  dist_enroll_hun dist_enroll_hun_sq dist_enroll_hun_cu dist_enroll_hun_qu
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("`h' CovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 

 foreach l in 1 2 3 4 {;
  quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  dist_enroll_hun dist_enroll_hun_sq dist_enroll_hun_cu dist_enroll_hun_qu
  pct_bl_hisp pct_bl_hisp_sq pct_bl_hisp_cu pct_bl_hisp_qu
  pov_rate_00 pov_rate_00_sq pov_rate_00_cu pov_rate_00_qu
  pct_bl_hisp_pov
  if pov_quart==`l'
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("`h'`l' CovWgt"); 
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
  estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
};

quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("`h' nocovWgt");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if fiscalyear==2000 [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);

 foreach l in 1 2 3 4 {;
  quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  if pov_quart==`l'
  [aw=enrollment], absorb(state) cl(state);
 eststo, title("`h'`l' nocovWgt"); 
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if fiscalyear==2000 & pov_quart==`l' [aw=enrollment];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

};

estout * using "$tables/CCD Resource_Outcomes.txt",
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/*CITS SASS Resource Regressions*/

foreach f of global files {;

foreach h of global s_resource_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   hispanic black_nh other male AGE_T  AGE_T_sq AGE_T_cu AGE_T_qu AGE_T_male grade_combo* math ela
   pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
   school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' cov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 };

foreach h of global s_resource_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' nocov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if survey_year==1999 [w=TFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
 };

};

estout * using "$tables/SASS Resource_Outcomes.txt",
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/*CITS SASS Time Use Regressions*/

foreach f of global files {;

foreach h of global time_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   hispanic black_nh other male AGE_T  AGE_T_sq AGE_T_cu AGE_T_qu AGE_T_male grade_combo* math ela
   pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
   school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' cov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 };
 
foreach h of global time_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' nocov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if survey_year==1999 [w=TFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
 };

};


estout * using "$tables/SASS Time_Outcomes.txt",
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/*CITS School Climate Outcomes*/

foreach f of global files {;

foreach h of global t_climate_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   hispanic black_nh other male AGE_T  AGE_T_sq AGE_T_cu AGE_T_qu AGE_T_male grade_combo* math ela
   pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
   school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h' cov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 };


foreach h of global p_climate_outcomes {;
 use "$sass_data/p_`f'.dta", clear;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  p_hispanic p_black_nh p_other p_male p_age p_age_sq p_age_cu p_age_qu p_age_male
  pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
  school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
  [pw=AFNLWGT], absorb(state) cl(state);
 eststo, title("`h' cov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 };


foreach h of global t_climate_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h' nocov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if survey_year==1999 [w=TFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

foreach h of global p_climate_outcomes {;
 use "$sass_data/p_`f'.dta", clear;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  [pw=AFNLWGT], absorb(state) cl(state);
 eststo, title("`h' nocov");
 lincom (NEWTREAT_nclb*6) + (36*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se);
 quietly sum `h' if survey_year==1999 [w=AFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

};


estout * using "$tables/School_Outcomes.txt",
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/**********************************Falsification********************************/

foreach f of global files {;

foreach h of global false_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
   hispanic black_nh other male AGE_T  AGE_T_sq AGE_T_cu AGE_T_qu AGE_T_male grade_combo* math ela
   pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
   school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h' CITS (Sample: `f')");
 lincom (NEWTREAT_nclb*6) + (30*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if survey_year==1999 [w=TFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

foreach h of global false_outcomes {;
 use "$sass_data/p_`f'.dta", clear;
 rename s_grade_combo_other s_omitted_combo;
quietly areg `h' year nclb yr_since_nclb NEWTREAT_year NEWTREAT_nclb NEWTREAT_yr_since 
  p_hispanic p_black_nh p_other p_male p_age p_age_sq p_age_cu p_age_qu p_age_male
  pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
  school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
  [pw=AFNLWGT], absorb(state) cl(state);
 eststo, title("`h' CITS (Sample: `f')");
 lincom (NEWTREAT_nclb*6) + (30*NEWTREAT_yr_since);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se=r(se);
 estadd scalar Effect_by_2008_t=r(estimate)/r(se); 
 quietly sum `h' if survey_year==1999 [w=AFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

estout * using "$tables/SASS_false_`f'.txt", 
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;
};

/***************DD Results*********************/

estimates clear;

/*DD SASS Resource Regressions*/

foreach f of global files {;

foreach h of global s_resource_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
   hispanic black_nh other male AGE_T  AGE_T_sq AGE_T_cu AGE_T_qu AGE_T_male grade_combo* math ela
   pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
   school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' cov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se); 
 };

foreach h of global s_resource_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' nocov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se);  
 quietly sum `h' if survey_year==1999 [w=TFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
 };

};

estout * using "$tables/DD_Resource_Outcomes.txt",
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/*DD SASS Time Use Regressions*/

foreach f of global files {;

foreach h of global time_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
   hispanic black_nh other male AGE_T  AGE_T_sq AGE_T_cu AGE_T_qu AGE_T_male grade_combo* math ela
   pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
   school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' cov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se); 
 };
 
foreach h of global time_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h'`f' nocov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se); 
 quietly sum `h' if survey_year==1999 [w=TFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
 };

};


estout * using "$tables/DD_Time_Outcomes.txt",
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;

/*DD School Climate Outcomes*/

foreach f of global files {;

foreach h of global t_climate_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
   hispanic black_nh other male AGE_T  AGE_T_sq AGE_T_cu AGE_T_qu AGE_T_male grade_combo* math ela
   pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
   school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h' cov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se); ; 
 };


foreach h of global p_climate_outcomes {;
 use "$sass_data/p_`f'.dta", clear;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
  p_hispanic p_black_nh p_other p_male p_age p_age_sq p_age_cu p_age_qu p_age_male
  pct_min pct_min_sq pct_min_cu pct_min_qu pct_lunch pct_lunch_sq pct_lunch_cu pct_lunch_qu 
  school_enroll_hun school_enroll_hun_sq school_enroll_hun_cu school_enroll_hun_qu pct_min_lunch s_grade_combo*
  [pw=AFNLWGT], absorb(state) cl(state);
 eststo, title("`h' cov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se); 
 };

foreach h of global t_climate_outcomes {;
 use "$sass_data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
   [pw=TFNLWGT], absorb(state) cl(state);
 eststo, title("`h' nocov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se);  
 quietly sum `h' if survey_year==1999 [w=TFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

foreach h of global p_climate_outcomes {;
 use "$sass_data/p_`f'.dta", clear;
 rename s_grade_combo_other s_omitted_combo;
 quietly areg `h' nclb2003 nclb2007 NEWTREAT_nclb2003 NEWTREAT_nclb2007 
  [pw=AFNLWGT], absorb(state) cl(state);
 eststo, title("`h' nocov");
 lincom (NEWTREAT_nclb2007*6);
 estadd scalar Effect_by_2008 = r(estimate);
 estadd scalar Effect_by_2008_se = r(se);
 estadd scalar Effect_by_2008_t = r(estimate)/r(se); 
 quietly sum `h' if survey_year==1999 [w=AFNLWGT];
 estadd scalar Yr2000_Mean = r(mean);
 estadd scalar Yr2000_SD = r(sd);
};

};


estout * using "$tables/DD_School_Outcomes.txt",
drop(*) 
cells(b(star fmt(3)) se(par))
starlevels(* 0.10 ** 0.05 *** 0.01)
stats(Effect_by_2008 Effect_by_2008_se Effect_by_2008_t Yr2000_Mean Yr2000_SD N, fmt(3 3 3 3 3 0) layout(@ (@) [@] @ @ @)) label replace;

estimates clear;
